// Persistence of Vision Ray Tracer Scene Description File
// File: tmwilder.pov
// Title: Survivors of the Imperial Star-Destroyer "Medusa"
// Vers: 3.1g.wmp.0.5a
// Desc: IRTC Entry for "Wilderness"
// Date: 06/00
// Auth: Tom Melly, http://www.tomandlu.f9.co.uk, tom@tomandlu.f9.co.uk
//

#version unofficial MegaPov 0.5;

#include "colors.inc"
                         
#declare quickAsteroids =   0;
#declare quickCostumes =    0;

#declare doBigAsteroid =    1;
#declare doAsteroids =      1;
#declare doFigures =        1;
#declare doSpace =          1;
#declare doStrDstryr =      1;

#declare Rand1 = seed(58563);

light_source{<0,0,0> color rgb<1,1,1>1.00 translate <-20000, 20000, -20000>}
light_source{<0,0,0> color rgb<1,1,1>*0.25 translate <3000, 3000, -3000> shadowless}
camera{location  <1.0, 0.0, -2.0> look_at   <0.0, 0.0,  0.0>}//z wads -2

// ----------------------------------------
#if (doSpace)
  #debug "parsing galaxy...\n"

  #declare galaxy_seed = 468240834; 
  #declare galaxy_objects = false;
  #declare galaxy_distance = 45000;
  #declare galaxy_bgstars = 3;
  #include "GALAXY.INC"

  #debug "done galaxy...\n"
#end

#if (doFigures)

  #debug "parsing figures...\n"

  #include "bmpeople.inc"
  #if (!quickCostumes)
    #declare RHand=0; //1 - Blaster, 0 - No Blaster
    #declare LHand=0; //1 - Blaster, 0 - No Blaster
    #include "trooper4.cdf"
  #end
  
  //************* far group **********************
  // first man - highest, waving
  #declare BM_Head_Rot   = <15,-20,0>; // x = Head position Front to Back 
  #declare BM_Neck_Rot = <15,-20,0>;   // Rotation vector for the neck (Note: "y" is not used)
  #declare BM_Torso_Rot= <0,20,15>;   // Rotation vector for the Upper Torso 
  #declare BM_RA_S2E   = <-35,0,-25>;  // Right Upperarm
  #declare BM_RA_E2W   = <55,0,-25>;  // Right Forearm
  #declare BM_RH_Rot   = <0,0,0>;  // Right Hand
  #declare BM_LA_S2E   = <130,-40,8>;  // Left Upperarm
  #declare BM_LA_E2W   = <140,0,3>;  // Left Forearm
  #declare BM_LH_Rot   = <0,0,0>;  // Left Hand
  #declare BM_RL_H2K   = <75,35,-15>;  // Right Thigh
  #declare BM_RL_K2A   = <-45,0,0>;  // Right Lower Leg
  #declare BM_RF_Rot   = <0,0,0>;  // Right Foot
  #declare BM_LL_H2K   = <-25,0,25>;  // Left Thigh
  #declare BM_LL_K2A   = <-25,0,25>;  // Left Lower Leg
  #declare BM_LF_Rot   = <0,0,0>;  // Left Foot
  
  Blob_Man(Male,1)
  #declare Man1 =
  object{
    BlobMan 
    transform BMO_Abdomen_F
  }
  
  // second man - right of highest, waving
  #declare BM_Head_Rot =<0,30,20>;//     Default: <0,0,0>     Head
  #declare BM_Neck_Rot =<50,0,0>;//     Default: <0,0,0>     Neck (Note y is not used)
  #declare BM_Torso_Rot =<50,50,20>;//    Default: <0,0,0>     Upper Torso (Chest)
  #declare BM_LA_S2E = <60,-180,45>;//z75       Default: <-8,0,8>    Left Upper Arm
  #declare BM_LA_E2W = <40,0,90>;//x-40      Default: <8,0,3>       Left Forearm
  #declare BM_RA_S2E = <-8,30,245>;//      Default: <-8,0,-8>   Right Upper Arm
  #declare BM_RA_E2W = <165,30,-3>;//      Default: <8,0,-3>    Right Forearm 
  #declare BM_RL_H2K = <45,90,-5>;//      Default: <8,0,-5>    Right Thigh 
  #declare BM_RL_K2A = <-8,0,3>;//      Default: <-8,0,3>    Right Lower Leg 
  #declare BM_LL_H2K = <80,0,5>;//      Default: <8,0,5>     Left Thigh 
  #declare BM_LL_K2A = <-15,0,3>;//      Default: <-8,0,-3>   Left Lower Leg 
  #declare BM_RH_Rot   = <0,0,0>;  // Right Hand
  #declare BM_LH_Rot   = <0,0,45>;  // Left Hand
  #declare BM_RF_Rot   = <-60,0,0>;  // Right Foot
  #declare BM_LF_Rot   = <-80,0,0>;  // Left Foot
  
  Blob_Man(Male,1)
  #declare Man2 =
  object{
    BlobMan 
    transform BMO_Abdomen_F
    rotate x*-75
    rotate y*-55
    translate <-0.60, -0.30, 0>
  }
  
  // grasping, just behind highest
  #declare BM_Head_Rot =	<30,-30,0>	  ;//	Default: <0,0,0>     Head
  #declare BM_Neck_Rot =	<0,0,0>	  ;//     Default: <0,0,0>     Neck (Note y is not used)
  #declare BM_Torso_Rot =	<25,10,0>	  ;//    	Default: <0,0,0>     Upper Torso (Chest)
  #declare BM_LA_S2E = 	<150,-40,8>	;//     Default: <-8,0,8>    Left Upper Arm
  #declare BM_LA_E2W = 	<160,-15,3>		;//     Default: <8,0,3>     Left Forearm
  #declare BM_RA_S2E = 	<100,80,-8>	;//     Default: <-8,0,-8>   Right Upper Arm
  #declare BM_RA_E2W = 	<110,-20,-3>	;//     Default: <8,0,-3>    Right Forearm 
  #declare BM_RL_H2K = 	<8,40,-5>	;//     Default: <8,0,-5>    Right Thigh 
  #declare BM_RL_K2A = 	<-65,0,3>	;//     Default: <-8,0,3>    Right Lower Leg 
  #declare BM_LL_H2K = 	<8,-40,5>		;//     Default: <8,0,5>     Left Thigh 
  #declare BM_LL_K2A = 	<-65,0,-3>	;//     Default: <-8,0,-3>   Left Lower Leg 
  #declare BM_RH_Rot = 	<0,0,0>		;// 	Right Hand
  #declare BM_LH_Rot = 	<0,0,0>		;// 	Left Hand
  #declare BM_RF_Rot = 	<-70,0,0>		;// 	Right Foot
  #declare BM_LF_Rot = 	<-70,0,0>		;// 	Left Foot
  
  Blob_Man(Male,1)
  #declare Man3 =
  object{
    BlobMan 
    transform BMO_Abdomen_F
    rotate x*-35
    rotate y*30
    translate x*0.10
    translate y*-0.30
    translate z*0.35
  }
  
  #declare Group1 =
  union{
    object{Man1}
    object{Man2}
    object{Man3}
    rotate y*210
  }
  
  //************* near group **********************
  // slumping man supporting body facing away from ship
  #declare BM_Head_Rot =	<0,-20,0>		;//	Default: <0,0,0>     Head
  #declare BM_Neck_Rot =	<0,0,0>		;//     Default: <0,0,0>     Neck (Note y is not used)
  #declare BM_Torso_Rot =	<-30,-20,15>		;//    	Default: <0,0,0>     Upper Torso (Chest)
  #declare BM_LA_S2E = 	<70,-30,8>	;//     Default: <-8,0,8>    Left Upper Arm
  #declare BM_LA_E2W = 	<80,-20,3>		;//     Default: <8,0,3>     Left Forearm
  #declare BM_RA_S2E = 	<75,10,-8>	;//     Default: <-8,0,-8>   Right Upper Arm
  #declare BM_RA_E2W = 	<210,0,-25>	;//     Default: <8,0,-3>    Right Forearm 
  #declare BM_RL_H2K = 	<105,10,-5>	;//     Default: <8,0,-5>    Right Thigh 
  #declare BM_RL_K2A = 	<30,25,3>	;//     Default: <-8,0,3>    Right Lower Leg 
  #declare BM_LL_H2K = 	<60,-55,15>		;//     Default: <8,0,5>     Left Thigh 
  #declare BM_LL_K2A = 	<-75,-75,-3>	;//     Default: <-8,0,-3>   Left Lower Leg 
  #declare BM_RH_Rot = 	<0,0,0>		;// 	Right Hand
  #declare BM_LH_Rot = 	<0,75,0>		;// 	Left Hand
  #declare BM_RF_Rot = 	<-45,15,10>		;// 	Right Foot
  #declare BM_LF_Rot = 	<-65,0,0>		;// 	Left Foot
  
  Blob_Man(Male,1)
  #declare Man4 =
  object{
    BlobMan 
    transform BMO_Abdomen_F
    rotate x*20
  }
  
  // man lying across despairing man
  #declare BM_Head_Rot =	<30,-30,-5>		;//	Default: <0,0,0>     Head
  #declare BM_Neck_Rot =	<20,0,-20>		;//     Default: <0,0,0>     Neck (Note y is not used)
  #declare BM_Torso_Rot =	<10,-20,-20>		;//    	Default: <0,0,0>     Upper Torso (Chest)
  #declare BM_LA_S2E = 	<65,-110,8>	;//     Default: <-8,0,8>    Left Upper Arm
  #declare BM_LA_E2W = 	<18,0,65>		;//     Default: <8,0,3>     Left Forearm
  #declare BM_RA_S2E = 	<-65,-60,-8>	;//     Default: <-8,0,-8>   Right Upper Arm
  #declare BM_RA_E2W = 	<8,50,-45>	;//     Default: <8,0,-3>    Right Forearm 
  #declare BM_RL_H2K = 	<55,20,-5>	;//     Default: <8,0,-5>    Right Thigh 
  #declare BM_RL_K2A = 	<5,0,-25>	;//     Default: <-8,0,3>    Right Lower Leg 
  #declare BM_LL_H2K = 	<45,-75,15>		;//     Default: <8,0,5>     Left Thigh 
  #declare BM_LL_K2A = 	<20,-65,10>	;//     Default: <-8,0,-3>   Left Lower Leg 
  #declare BM_RH_Rot = 	<0,0,0>		;// 	Right Hand
  #declare BM_LH_Rot = 	<20,60,0>		;// 	Left Hand
  #declare BM_RF_Rot = 	<-50,0,0>		;// 	Right Foot
  #declare BM_LF_Rot = 	<-45,0,0>		;// 	Left Foot
  
  Blob_Man(Male,1)
  #declare Man5 =
  object{
    BlobMan 
    transform BMO_Abdomen_F
    rotate x*55
    rotate z*10
    rotate y*-10
    translate x*0.25
    translate y*0.05
    translate z*-0.25
  }
  
  #declare Group2 =
  union{
    object{Man4}
    object{Man5}
    rotate x*-5
    rotate y*35
    rotate z*-5
  }
  
  #declare AllGroups =
  union{
    object{Group1 translate z*1.5 translate y*-0.2}
    object{Group2 translate y*-0.32}
  }
  
  object{AllGroups
    rotate y*12
    translate <-0.1, 0, -0.35>
  }

  #debug "done figures...\n"
#end

//asteroids
#declare asteroidTexture =
  texture{
    pigment{rgb<0.55, 0.50,0.45>}
    normal{
      average
      normal_map{
        [granite 5 scale .1 turbulence 0.25]
        [dents 15 scale 1 turbulence 0.25]
        [agate 2 scale 1 turbulence 0.5]
        [bozo 15 scale 1 turbulence 0.25]
      }
    }
  }


#if (doAsteroids)
  #debug "parsing asteroids...\n"

  #declare noComponents = 0;
  #declare noRocks = 0;
  #declare loopCount = 0;
  #declare tempRocks = 0;
  
  #macro MakeRock()
    #if (rand(Rand1) < 0.1 & zPos > 4000)
      #declare noBlobs = int((rand(Rand1)+1) * 500);
    #else
      #declare noBlobs = int((rand(Rand1)+1) * 25);
    #end

    #declare noComponents = noComponents + noBlobs;
    #declare blobRange = pow(noBlobs, 1/3) * 1.25;
    #declare blobDiam = pow(noBlobs, 1/4) / 1.25;
    
    blob{
      threshold 1                               
      #while (noBlobs > 0)
        sphere{
          <0,0,0>, (rand(Rand1) + 1) * blobDiam, (rand(Rand1)-0.25) * 2

          #declare xShift = rand(Rand1); // 0-1
          #declare yzShift = (1 - xShift)*2; // 2-0 when x = 1, yz=0
          #declare yShift = (yzShift - (rand(Rand1) * yzShift)) / (rand(Rand1) + 2);//1-0 if x = 1, then y = 0
          #declare zShift = 1 - xShift - yShift;//

          #declare xShift = xShift * blobRange;
          #declare yShift = yShift * blobRange;
          #declare zShift = zShift * blobRange;
          
          #if (rand(Rand1) > 0.5)
            #declare xShift = xShift * -1;
          #end
          #if (rand(Rand1) > 0.5)
            #declare yShift = yShift * -1;
          #end
          #if (rand(Rand1) > 0.5)
            #declare zShift = zShift * -1;
          #end
          
          translate <xShift, yShift, zShift>
        }
        #declare noBlobs = noBlobs - 1;
      #end

      #declare xScale = rand(Rand1)+0.5;
      #declare yScale = rand(Rand1)+0.5;    
      #declare zScale = rand(Rand1)+0.5;
      scale <(xScale*5) + 5, (yScale*5) + 5, (zScale*5) + 5>

      #declare yPos = ((rand(Rand1) - 0.5) * 500);
      translate <xPos, yPos, zPos + ((rand(Rand1)-0.5)*100)>
      rotate y*-26.5

      texture{asteroidTexture}
    }
  
  #end
  
  // asteroids
  #declare zPos = 1000;
  #declare zFinal = 40000;  
  #while (zPos  < zFinal)
    #declare loopCount = loopCount + 1;
    #if (quickAsteroids)
      #declare xPos = -0.1*zPos;
      #while (xPos < 0.1*zPos)
        MakeRock()
        #declare noRocks = noRocks + 1;
        #declare xPos = xPos + (500*(rand(Rand1)+0.5));
      #end
    #else
      #declare xPos = -0.7*zPos;//700 - 7000
      #while (xPos < 0.7*zPos)
        MakeRock()
        #declare noRocks = noRocks + 1;
        #declare xPos = xPos + (500*(rand(Rand1)+0.5));
      #end
    #end
    #declare zPos = zPos + (1000 * (rand(Rand1)+0.5));//50 *
    #debug concat("Total Components: ", str(noComponents, 8,1),         "  Total Rocks:     ", str(noRocks, 8,1), "\n")
    #debug concat("Av. Comps/Rock:   ", str(noComponents/noRocks, 8,1), "  Av. Rocks/Loop:  ", str(noRocks/loopCount, 8,1), "\n\n")
    #debug concat("Countdown:        ", str(zFinal - zPos, 8,1),        "  This Loop Rocks: ", str(noRocks - tempRocks, 8,1),  "\n\n")
    #declare tempRocks = noRocks;
  #end
    #debug concat("******************************************************\n\n")
    #debug concat("Total Components: ", str(noComponents, 8,1),         "  Total Rocks:     ", str(noRocks, 8,1), "\n")
    #debug concat("Av. Comps/Rock:   ", str(noComponents/noRocks, 8,1), "  Av. Rocks/Loop:  ", str(noRocks/loopCount, 8,1), "\n")
  #declare totRocks = 0;

  #debug "done asteroids...\n"
#end

#if (doBigAsteroid)
  #debug "parsing big asteroid...\n"
  
  #declare isoPlatformB =
  isosurface{
    #declare rockFunc = function {"ridgedMF" <1,2,5,0.5,10>}
    function{x^2 + y^2*12 + z^2 + rockFunc(x*8,y*8,z*8)/2 + noise3d(x/2,y/2,z/2)*2}
    max_gradient 26
    eval
    threshold 1
    sign 1
    accuracy .001
    contained_by{box{<-2,-2,-2>,<2,2,2>}}
  }
  
  object{
    isoPlatformB
    scale 4
    texture{asteroidTexture}
    translate <0.2, -1.2, 0.5> // from figures
  }

  #debug "done big asteroid...\n"
#end

#if (doStrDstryr)
  #debug "parsing StarDestroyer...\n"

  #include "sd.inc"
  object {StarDestroyer
    rotate z*55
    rotate y*-85
    translate z*30000
    translate y*7000
    rotate y*-7
  }

  #debug "done StarDestroyer...\n"
#end
